'use client';

import PageHeader from "@/components/layout/Pages/PageHeader"
import { useEffect, useRef, useState } from "react";
import { useLocale } from 'next-intl';

import { motion, Variants, useScroll, useTransform } from "motion/react"
import ItemSection from "./compenents/item";


const cardVariants: Variants = {
  offscreen: {
    y: 150,
    opacity: 0,
    rotate: 5
  },
  onscreen: (i: number) => ({
    y: 0,
    opacity: 1,
    rotate: 0,
    transition: {
      type: "spring",
      bounce: 0.4,
      duration: 0.8,
      delay: i * 0.2
    },
  }),
};

export default function Content() {
  const locale = useLocale() as 'ar' | 'en';
  const [title, setTitle] = useState<any>({})
  const [description, setDescription] = useState<any>({})

  useEffect(() => {
    setTitle({
      ar: "من نحن ..",
      en: ""
    })
    setDescription({
      ar: "نحن فريق متخصص يجمع بين الخبرة الطويلة والرؤية الحديثة لنقدّم حلولًا مبتكرة ومتكاملة، <br />نلتزم فيها بالجودة والدقة ونضع احتياجات عملائنا في مقدمة أولوياتنا.",
      en: ""
    })
  }, [])

  const features = [
    {
      id: 1,
      title: "جودة بلا تنازل",
      description: "نلتزم بأعلى معايير الجودة في كل مشروع لضمان نتائج متميزة ومستدامة.",
      path: "M68.7107 34.4579L55.6587 30.1058C55.2313 29.9634 54.7693 29.9634 54.342 30.1058L41.2899 34.4579C39.2147 35.1472 37.4095 36.473 36.1308 38.2468C34.8521 40.0207 34.165 42.1524 34.167 44.3391V54.9995C34.167 70.7558 53.3337 79.4579 54.1545 79.8204C54.4208 79.9387 54.7089 79.9998 55.0003 79.9998C55.2917 79.9998 55.5799 79.9387 55.8462 79.8204C56.667 79.4579 75.8337 70.7558 75.8337 54.9995V44.3391C75.8357 42.1524 75.1485 40.0207 73.8698 38.2468C72.5911 36.473 70.7859 35.1472 68.7107 34.4579ZM64.8295 50.2433L55.9295 59.1433C55.5653 59.5099 55.1319 59.8006 54.6544 59.9983C54.177 60.1961 53.665 60.2971 53.1482 60.2954H53.0795C52.5522 60.2873 52.032 60.1723 51.5504 59.9575C51.0687 59.7426 50.6357 59.4323 50.2774 59.0454L45.4732 54.0454C45.2652 53.8523 45.0988 53.6188 44.9842 53.3591C44.8696 53.0995 44.8093 52.8192 44.807 52.5353C44.8046 52.2515 44.8603 51.9702 44.9705 51.7087C45.0808 51.4472 45.2433 51.211 45.4482 51.0145C45.653 50.8181 45.8958 50.6655 46.1617 50.5663C46.4276 50.4671 46.711 50.4232 46.9945 50.4374C47.2779 50.4516 47.5555 50.5236 47.8102 50.6489C48.0648 50.7742 48.2912 50.9502 48.4753 51.1662L53.1503 56.0412L61.8753 47.2912C62.2683 46.9117 62.7945 46.7017 63.3407 46.7065C63.887 46.7112 64.4095 46.9303 64.7958 47.3166C65.1821 47.7028 65.4012 48.2254 65.4059 48.7716C65.4107 49.3179 65.2007 49.8441 64.8212 50.237L64.8295 50.2433Z",
      clipId: "clip0_14147_2949"
    },
    {
      id: 2,
      title: "التزام بالوقت والتسليم",
      description: "نضمن إنجاز المشاريع بدقة وفي المواعيد المحددة، مع مراعاة جميع التفاصيل.",
      path: "M60.7956 70.2479C62.8352 71.1479 65.0852 71.6583 67.4539 71.6646C67.4664 73.6375 66.8081 75.5667 65.4956 77.0917C63.9018 78.9417 61.5914 80 59.1539 80H38.3414C35.9039 80 33.5935 78.9375 32.0018 77.0875C30.4331 75.2667 29.7373 72.8708 30.0914 70.5104C30.9373 64.8875 34.0185 59.6812 39.2602 55.0021C34.0164 50.3208 30.9352 45.1146 30.0893 39.4917C29.7352 37.1313 30.4331 34.7354 31.9998 32.9146C33.5935 31.0625 35.9039 30 38.3414 30H59.1539C61.5914 30 63.9018 31.0583 65.4956 32.9083C66.8081 34.4313 67.4664 36.3625 67.4539 38.3354C58.2852 38.3604 50.8331 45.825 50.8331 55C50.8331 56.3667 51.0164 57.6875 51.3289 58.9604L50.0539 57.9437C49.2935 57.3396 48.2206 57.3396 47.4602 57.9396L45.9935 59.1042C42.7498 61.6687 38.4539 65.7958 36.3998 70.8875C36.1393 71.5312 36.2185 72.2583 36.6039 72.8333C36.9914 73.4062 37.6393 73.75 38.331 73.75H59.1643C59.8581 73.75 60.506 73.4083 60.8914 72.8333C61.2789 72.2604 61.356 71.5292 61.0956 70.8875C61.0081 70.6687 60.8935 70.4646 60.7977 70.25L60.7956 70.2479ZM79.9998 55C79.9998 61.8937 74.3935 67.5 67.4998 67.5C60.606 67.5 54.9998 61.8937 54.9998 55C54.9998 48.1062 60.606 42.5 67.4998 42.5C74.3935 42.5 79.9998 48.1062 79.9998 55ZM72.0977 56.6521L69.5831 54.1375V49.7917C69.5831 48.6417 68.6498 47.7083 67.4998 47.7083C66.3498 47.7083 65.4164 48.6417 65.4164 49.7917V55C65.4164 55.5521 65.6352 56.0833 66.0268 56.4729L69.1518 59.5979C69.5581 60.0042 70.0914 60.2083 70.6248 60.2083C71.1581 60.2083 71.6914 60.0042 72.0977 59.5979C72.9123 58.7833 72.9123 57.4667 72.0977 56.6521ZM41.7623 69.5812H55.7248C53.7998 66.6042 50.9352 63.975 48.7498 62.2333C46.5685 63.9583 43.6831 66.5979 41.7623 69.5812Z",
      clipId: "clip0_14147_2955"
    },
    {
      id: 3,
      title: "فريق متخصص ومؤهل",
      description: "يضم فريقنا خبراء ومحترفين في كافة مجالات البناء لضمان التنفيذ الأمثل.",
      path: "M66.4584 46.6667C71.0605 46.6667 74.7918 50.3979 74.7918 55C74.7918 59.6021 71.0605 63.3333 66.4584 63.3333C61.8564 63.3333 58.1251 59.6021 58.1251 55C58.1251 50.3979 61.8564 46.6667 66.4584 46.6667ZM55.0001 46.6667C59.6022 46.6667 63.3334 42.9354 63.3334 38.3333C63.3334 33.7312 59.6022 30 55.0001 30C50.398 30 46.6668 33.7312 46.6668 38.3333C46.6668 42.9354 50.398 46.6667 55.0001 46.6667ZM43.5418 63.3333C48.1439 63.3333 51.8751 59.6021 51.8751 55C51.8751 50.3979 48.1439 46.6667 43.5418 46.6667C38.9397 46.6667 35.2084 50.3979 35.2084 55C35.2084 59.6021 38.9397 63.3333 43.5418 63.3333ZM79.9043 76.1063C78.3084 69.8125 72.5668 65.4167 65.9376 65.4167C61.6001 65.4167 57.6668 67.3229 55.0001 70.3917C52.3355 67.325 48.4022 65.4167 44.0626 65.4167C37.4355 65.4167 31.6918 69.8125 30.0959 76.1063C29.6709 77.7792 30.6834 79.4792 32.3564 79.9042C34.0314 80.3312 35.7314 79.3167 36.1543 77.6437C36.6189 75.8104 37.7334 74.2771 39.2168 73.2188L42.1668 76.9979C43.148 78.225 45.0147 78.225 45.998 76.9979L48.973 73.2604C50.4251 74.3187 51.5126 75.8375 51.9709 77.6458C51.9772 77.6729 52.5397 80.0042 55.0022 80.0042C57.4647 80.0042 58.023 77.675 58.0293 77.6458C58.4939 75.8125 59.6084 74.2812 61.0918 73.2208L64.0418 77C65.023 78.2271 66.8897 78.2271 67.873 77L70.848 73.2625C72.3022 74.3208 73.3876 75.8396 73.8459 77.6479C74.2689 79.3208 75.9793 80.3333 77.6418 79.9083C79.3168 79.4833 80.3272 77.7833 79.9043 76.1104V76.1063Z",
      clipId: "clip0_14147_2961"
    },
    {
      id: 4,
      title: "تقنيات متقدمة",
      description: "نستخدم أحدث التقنيات والأساليب الهندسية لتعزيز الكفاءة والدقة في العمل.",
      path: "M80 36.9913V59.1663C80 62.6184 77.2021 65.4163 73.75 65.4163H69.7104C67.3396 65.4163 65.4167 63.4934 65.4167 61.1226C65.4167 59.9851 65.8687 58.8913 66.675 58.0872L75.8333 48.9288V40.0726L63.3333 51.8497V54.9997C63.3333 57.3018 61.4687 59.1663 59.1667 59.1663H34.1708C31.8708 59.1663 30.0063 57.3038 30.0042 55.0038C30.0042 52.7018 31.8688 50.833 34.1708 50.833H58.3396L75.2396 34.933C75.7646 34.4393 76.4562 34.1663 77.175 34.1663C78.7354 34.1663 80 35.4309 80 36.9913ZM52.2167 35.7809C51.2104 33.5309 48.975 32.083 46.5104 32.083H43.5417C40.6646 32.083 38.3333 34.4143 38.3333 37.2913V46.6663H57.0833L52.2167 35.7809ZM63.3333 71.6663C63.3333 76.2601 59.5937 79.9997 55 79.9997H38.3333C33.7396 79.9997 30 76.2601 30 71.6663C30 67.0726 33.7396 63.333 38.3333 63.333H55C59.5937 63.333 63.333 67.0705 63.3333 71.6663ZM42.5 71.6663C42.5 69.9413 41.1 68.5413 39.375 68.5413C37.65 68.5413 36.25 69.9413 36.25 71.6663C36.25 73.3913 37.65 74.7913 39.375 74.7913C41.1 74.7913 42.5 73.3913 42.5 71.6663ZM57.0833 71.6663C57.0833 69.9413 55.6833 68.5413 53.9583 68.5413C52.2333 68.5413 50.8333 69.9413 50.8333 71.6663C50.8333 73.3913 52.2333 74.7913 53.9583 74.7913C55.6833 74.7913 57.0833 73.3913 57.0833 71.6663Z",
      clipId: null
    }
  ];

  const items = [
    {
      id: 1,
      title: "رسالتنا",
      description: "تقديم خدمات إنشائية موثوقة بخطط واضحة وجودة عالية، مع حلول تضيف قيمة حقيقية لعملائنا.",
      bgColor: "bg-gray-50",
      textColor: "text-gray-600",
      titleColor: "text-[#2E53A2]",
      iconColor: "#2E53A2",
      zIndex: "z-30",
      marginClass: "md:-ml-5",
      roundedClass: "rounded-s-lg",
      clipPathClass: "md:[clip-path:polygon(20px_0,100%_0,calc(100%-0px)_50%,100%_100%,20px_100%,0_50%)]",
      iconPath: "M16.25 -0.00488281H6.25C2.80375 -0.00488281 0 2.79887 0 6.24512V22.3126C0 23.3039 0.54375 24.2114 1.4175 24.6801C1.815 24.8939 2.25125 24.9989 2.68625 24.9989C3.20625 24.9989 3.725 24.8476 4.175 24.5489L9.12875 21.2451H16.25C19.6963 21.2451 22.5 18.4414 22.5 14.9951V6.24512C22.5 2.79887 19.6963 -0.00488281 16.25 -0.00488281ZM30 11.2451V27.3126C30 28.3039 29.4562 29.2114 28.5825 29.6801C28.185 29.8939 27.7488 29.9989 27.3137 30.0001C26.7937 30.0001 26.275 29.8489 25.8262 29.5501L20.8713 26.2451H13.75C11.9375 26.2451 10.3162 25.4564 9.17375 24.2201L9.885 23.7451H16.25C21.0737 23.7451 25 19.8189 25 14.9951V6.24512C25 5.86012 24.9662 5.48512 24.9187 5.11262C27.8075 5.66262 30 8.19887 30 11.2451Z",
      clipId: null
    },
    {
      id: 2,
      title: "رؤيتنا",
      description: "أن نكون شركة رائدة في قطاع الإنشاء عبر التقنيات الحديثة وفرق عمل متميزة.",
      bgColor: "bg-orange-500",
      textColor: "text-white",
      titleColor: "text-white",
      iconColor: "white",
      zIndex: "z-20",
      marginClass: "md:-ml-5",
      roundedClass: "",
      clipPathClass: "md:[clip-path:polygon(20px_0,100%_0,calc(100%-20px)_50%,100%_100%,20px_100%,0_50%)]",
      iconPath: "M29.7766 13.9762C28.6791 11.5762 24.3753 3.75 15.0003 3.75C5.62531 3.75 1.32156 11.5762 0.224063 13.9762C-0.0746875 14.6275 -0.0746875 15.375 0.224063 16.0262C1.32156 18.4237 5.62531 26.25 15.0003 26.25C24.3753 26.25 28.6791 18.4237 29.7766 16.0238C30.0741 15.3738 30.0741 14.6262 29.7766 13.9762ZM15.0003 21.25C12.9141 21.25 11.0778 20.2175 9.94281 18.6462L11.8216 16.7675L13.6966 18.6425L17.0803 15.2587L18.6966 16.875V12.5887C18.6966 12.1938 18.3766 11.875 17.9828 11.875H13.6966L15.3128 13.4913L13.6966 15.1075L11.8216 13.2325L8.86906 16.185C8.79531 15.8012 8.74906 15.4063 8.74906 15.0013C8.74906 11.55 11.5478 8.75125 14.9991 8.75125C18.4503 8.75125 21.2491 11.55 21.2491 15.0013C21.2491 18.4525 18.4503 21.2512 14.9991 21.2512L15.0003 21.25Z",
      clipId: null
    },
    {
      id: 3,
      title: "قيمنا",
      description: "الشفافية والجودة والابتكار والعمل الجماعي لبناء شراكات طويلة الأمد.",
      bgColor: "bg-gray-50",
      textColor: "text-gray-600",
      titleColor: "text-[#2E53A2]",
      iconColor: "#2E53A2",
      zIndex: "z-10",
      marginClass: "",
      roundedClass: "rounded-e-lg",
      clipPathClass: "md:[clip-path:polygon(0px_0,100%_0,calc(100%-20px)_50%,100%_100%,0px_100%,0_50%)]",
      iconPath: "M30 11.25C29.8381 12.1576 29.4774 13.0182 28.9438 13.77L17.965 28.545C17.6169 28.9947 17.1712 29.3593 16.6614 29.6113C16.1516 29.8633 15.5912 29.9961 15.0226 29.9996C14.4539 30.0031 13.8919 29.8772 13.3791 29.6315C12.8663 29.3858 12.4161 29.0266 12.0625 28.5813L1.03 13.5C0.56135 12.8209 0.230516 12.0565 0.05625 11.25H7.89125L13.8325 26.6988C13.9229 26.9351 14.0829 27.1385 14.2914 27.2819C14.4999 27.4254 14.7469 27.5022 15 27.5022C15.2531 27.5022 15.5001 27.4254 15.7086 27.2819C15.9171 27.1385 16.0771 26.9351 16.1675 26.6988L22.1087 11.25H30ZM22.125 8.75H29.9463C29.7561 7.90427 29.3912 7.10764 28.875 6.41125L25.6775 2.09375C25.2145 1.44657 24.6038 0.919064 23.8963 0.554949C23.1887 0.190833 22.4045 0.000595795 21.6088 2.41697e-06H18.8587L22.125 8.75ZM13.885 2.41697e-06L10.5613 8.75H19.4513L16.1938 2.41697e-06H13.885ZM7.8875 8.75L11.21 2.41697e-06H8.3075C7.51848 -0.00077429 6.74053 0.185659 6.03757 0.543986C5.3346 0.902313 4.72668 1.42231 4.26375 2.06125L1.1725 6.11375C0.581006 6.88879 0.179431 7.7917 0 8.75H7.8875ZM19.43 11.25H10.57L15 22.7675L19.43 11.25Z",
      clipId: "clip0_14147_2820"
    }
  ];



  const history = [
    {
      "id": 1,
      "year": "2003",
      "section": {
        "ar": "البداية",
        "en": "The Beginning"
      },
      "title": {
        "ar": "التأسيس",
        "en": "Establishment"
      },
      "description": {
        "ar": "تأسست شركة السلام لتصبح شركة ناشئة متخصصة في قطاع البناء، وبدأت بتقديم خدمات إنشائية للمشاريع السكنية والإدارية والخدمية.",
        "en": "Al-Salam Company was founded as a startup specialized in the construction sector, starting by providing construction services for residential, administrative, and service projects."
      }
    },
    {
      "id": 2,
      "year": "2010",
      "section": {
        "ar": "النمو",
        "en": "Growth"
      },
      "title": {
        "ar": "التوسع في المشروعات الحكومية",
        "en": "Expansion in Government Projects"
      },
      "description": {
        "ar": "بدأت الشركة العمل مع الجهات الحكومية والمؤسسات العامة والخاصة، لتثبت كفاءتها في تنفيذ المشاريع الكبرى.",
        "en": "The company began working with government entities and public and private institutions, proving its efficiency in executing major projects."
      }
    },
    {
      "id": 3,
      "year": "2015",
      "section": {
        "ar": "التخصص",
        "en": "Specialization"
      },
      "title": {
        "ar": "دخول قطاع المشاريع التعليمية والصحية",
        "en": "Entering Educational & Health Sectors"
      },
      "description": {
        "ar": "تنفيذ مشاريع مثل الجامعات والمدارس والمستشفيات، مع التركيز على الجودة العالية وإدارة المشاريع بفعالية.",
        "en": "Executing projects such as universities, schools, and hospitals, with a focus on high quality and effective project management."
      }
    },
    {
      "id": 4,
      "year": "2020",
      "section": {
        "ar": "التنوع",
        "en": "Diversification"
      },
      "title": {
        "ar": "التوسع في القطاع التجاري والسكني",
        "en": "Commercial & Residential Expansion"
      },
      "description": {
        "ar": "تنفيذ مولات تجارية ومجمعات سكنية ضخمة، مع مشاريع مبتكرة في القاهرة الكبرى والمدن الجديدة.",
        "en": "Executing commercial malls and massive residential complexes, featuring innovative projects in Greater Cairo and new cities."
      }
    },
    {
      "id": 5,
      "year": "2023",
      "section": {
        "ar": "الابتكار",
        "en": "Innovation"
      },
      "title": {
        "ar": "اعتماد التقنيات الحديثة",
        "en": "Adopting Modern Technologies"
      },
      "description": {
        "ar": "اعتماد تقنيات البناء المتقدمة وتطوير فرق العمل، لتعزيز الكفاءة وجودة التنفيذ وتسريع إنجاز المشاريع.",
        "en": "Adopting advanced construction technologies and developing teams to enhance efficiency, execution quality, and accelerate project completion."
      }
    },
    {
      "id": 6,
      "year": "2024",
      "section": {
        "ar": "التعاون",
        "en": "Collaboration"
      },
      "title": {
        "ar": "شراكات استراتيجية وتنوع الخدمات",
        "en": "Strategic Partnerships & Service Variety"
      },
      "description": {
        "ar": "توسيع خدمات الشركة لتشمل المصانع والمعامل والورش المتكاملة، وإنشاء شراكات قوية مع الموردين والمقاولين لتحقيق أعلى معايير الجودة.",
        "en": "Expanding company services to include factories, labs, and integrated workshops, establishing strong partnerships with suppliers and contractors to achieve the highest quality standards."
      }
    },
    {
      "id": 7,
      "year": "2025",
      "section": {
        "ar": "التميز",
        "en": "Excellence"
      },
      "title": {
        "ar": "الريادة والتميز",
        "en": "Leadership and Excellence"
      },
      "description": {
        "ar": "تسعى شركة السلام لتكون من الشركات الرائدة في مصر في قطاع البناء من خلال الابتكار والجودة وإدارة المشاريع المتكاملة، لتصبح الشريك الموثوق لجميع العملاء.",
        "en": "Al-Salam Company strives to be a leading construction company in Egypt through innovation, quality, and integrated project management, becoming the trusted partner for all clients."
      }
    }
  ]

  return (
    <>
      <PageHeader title={title[locale || 'ar']} description={description[locale || 'ar']} />
      <div className='h-full min-h-48 w-full flex flex-col justify-start items-center gap-0 overflow-hidden'>

        <div className="container flex flex-col md:flex-row justify-center items-center gap-5 py-10 px-4 md-px-0">
          <motion.div
            initial={{ opacity: 0, x: 50 }}
            whileInView={{ opacity: 1, x: 0 }}
            transition={{ duration: 0.8 }}
            className="flex w-full items-center content-center align-middle">
            <img title={title[locale || 'ar']} alt={title[locale || 'ar']} src={'/assets/images/00001.png'} className={`h-auto m-auto max-w-full w-115.5`} />
          </motion.div>
          <div className="flex flex-col gap-8 w-full items-start content-start align-middle">
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.2, duration: 0.8 }}
              className="text-main-orange text-[36px] font-bold font-main">شركة السلام للمقاولات</motion.div>
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.4, duration: 0.8 }}
              className="text-start text-[16px] text-gray-600 font-almarai" dangerouslySetInnerHTML={{ __html: "شركة السلام هي شركة رائدة متخصصة في تنفيذ المشروعات الهندسية المتكاملة بمختلف أنواعها، تشمل المنشآت الصحية، التعليمية، الإدارية، الصناعية، والتجارية، بالإضافة إلى الهياكل المعدنية والمجمعات السكنية.<br /> منذ تأسيسنا في أوائل عام 2003، تمكّنا من التوسع بخطى ثابتة لنصبح شريكًا موثوقًا للقطاعين العام والخاص، من خلال تقديم حلول إنشائية متكاملة تعتمد على أعلى معايير الجودة والابتكار وإدارة المشاريع الاحترافية." }}></motion.div>
          </div>
        </div>

        <div className="container rounded-lg flex flex-col md:flex-row justify-center items-stretch px-2 md:px-0">
          {items.map((item, index) => (
            <motion.div
              key={item.id}
              custom={index}
              initial="offscreen"
              whileInView="onscreen"
              viewport={{ once: false, amount: 0.3 }}
              variants={cardVariants}

              className={`relative flex-1 flex flex-col h-auto min-h-47.5 py-10 px-7 justify-center items-center align-middle content-center 
                ${item.bgColor} 
                ${item.zIndex} 
                ${item.marginClass} 
                ${item.roundedClass} 
                ${item.clipPathClass}
              `}
            >
              <div className="flex w-full flex-row gap-5 justify-start">
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                  {item.clipId ? (
                    <>
                      <g clipPath={`url(#${item.clipId})`}>
                        <path d={item.iconPath} fill={item.iconColor} />
                      </g>
                      <defs>
                        <clipPath id={item.clipId}>
                          <rect width="30" height="30" fill="white" />
                        </clipPath>
                      </defs>
                    </>
                  ) : (
                    <path d={item.iconPath} fill={item.iconColor} />
                  )}
                </svg>
                <div className={`${item.titleColor} font-black text-[24px]`}>
                  {item.title}
                </div>
              </div>
              <div className={`${item.textColor} text-[16px] font-main mt-2`}>
                {item.description}
              </div>
            </motion.div>
          ))}
        </div>

        <motion.div
          initial={{ opacity: 0, x: 50 }}
          whileInView={{ opacity: 1, x: 0 }}
          transition={{ duration: 0.8 }}
          className="container flex flex-col justify-center items-center gap-5 py-10 mt-20"
        >
          <div className="flex flex-col gap-8 w-full items-start content-start align-middle">
            <div className="text-main-orange text-[36px] font-bold font-main">تاريخ الشركة</div>
          </div>
        </motion.div>
        <div className="container p-2 md:p-0 flex flex-col  gap-10 w-full justify-start items-start">


          {
            history.map((item, index) => <ItemSection count={history.length} index={index} key={index} id={item.id} year={item.year} section={item.section} title={item.title} locale={locale} description={item.description}  />)
          }

        </div>
        <motion.div
          initial={{ opacity: 0, x: 50 }}
          whileInView={{ opacity: 1, x: 0 }}
          transition={{ duration: 0.8 }}
          className="container flex flex-col justify-center items-center gap-5 py-10"
        >
          <div className="flex flex-col w-full items-start content-start align-middle">
            <div className="text-main-orange text-[36px] font-bold font-main">لماذا تختار السلام؟</div>
            <div className="text-main-blue text-[16px] font-light font-almarai">نظرة مختصرة على مميزاتنا فى السوق</div>
          </div>
        </motion.div>

        <div className="container p-2 md:p-0 grid grid-cols-2 lg:grid-cols-4 gap-4 w-full justify-start items-stretch">
          {features.map((item, index) => (
            <motion.div
              key={item.id}
              custom={index}
              initial="offscreen"
              whileInView="onscreen"
              viewport={{ once: false, amount: 0.2 }}
              variants={cardVariants}
              className="flex flex-col gap-4 p-3 w-full h-full bg-gray-50 rounded-xl"
            >
              <svg width="110" height="110" viewBox="0 0 110 110" fill="none" xmlns="http://www.w3.org/2000/svg">
                <rect x="4" y="4" width="102" height="102" rx="51" fill="#FF6400" />
                <rect x="4" y="4" width="102" height="102" rx="51" stroke="#F5F5F5" strokeWidth="8" />

                {item.clipId ? (
                  <>
                    <g clipPath={`url(#${item.clipId})`}>
                      <path d={item.path} fill="white" />
                    </g>
                    <defs>
                      <clipPath id={item.clipId}>
                        <rect width="50" height="50" fill="white" transform="translate(30 30)" />
                      </clipPath>
                    </defs>
                  </>
                ) : (
                  <path d={item.path} fill="white" />
                )}
              </svg>
              <div className="text-[#2E53A2] font-bold text-[18px] font-main">{item.title}</div>
              <div className="text-gray-500 text-[14px] font-almarai font-light">{item.description}</div>
            </motion.div>
          ))}
        </div>
      </div>
    </>
  );
}